dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 3, 280, 300, "assets/images/table/redtable", "assets/images/food/item_mark3", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 0;
maxCoupleHappiness = 1000;
numServers = 1;

-- Guest 1
guest = LManager.GenGuest(male01);
guest.matchType = table1;
guest.waitBeforeDinner = 4500;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 1, 1000);

--Guest 2
guest = LManager.GenGuest(female01);
guest.matchType = male01;
guest.waitBeforeDinner = 10000;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(2, 2, 2000);

-- Guest 3

guest = LManager.GenGuest(male04);
guest.matchType = female01;
guest.waitBeforeDinner = 8000;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(3, 3, 2500);

LManager:AdjustGuestTolerance(300);

-- Set up the Level Settings
LManager:SetLevelNumber(1,1);
LManager:SetLevelScores(600, 1000);
LManager:SetLevelTime(300000);

-- slow, fast 1, fast 2
LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/Dance Dance 1.ogg","assets/audio/music/Disco Dance 1.ogg");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );

TutorialSteps =
{
	start =
	{
		action = function()
			PauseCook();
			PauseWaitress();
			PauseDishBin();
			RestrictSeatingToSpecificChairNumber( 1 );
			end,
		triggers = 
		{
			[1] = { condition = "REQUEST_DESIRE", parameter = "WANT_SIT", next = "WantToSit" },
		},
	},
	
	WantToSit = 
	{
		action = function()
			PauseSeating();
			TextBox(110, 90, "tutorialStep1", 9999000);
			PlaceArrow(400, 260);
		end,
		triggers =
		{
			[1] = { condition = "IS_SEATED", parameter = "", next = "FirstGuestSeated" },
		}
	},


	
	FirstGuestSeated = 
	{
		action = function()
			UnpauseWaitress();
			UnpauseCook();
			TurnOffRestrictedSeating();
			TextBox(480, 240, "tutorialStep2", 9999000);
			HideArrows();
			RestrictServerPickUpToGiftsOnly();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_GIFT", next = "ReadyForAppetizer" },
		}
	},

	ReadyForAppetizer = 
	{
		action = function()		
			TextBox(30, 180, "tutorialStep3", 9999000);
			HideArrows();
			RestrictServerPickUpToAppetizersOnly();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_PICKEDUP", parameter = "BONUS_APPETIZER", next = "PickedUpOneAppetizer" },
		}
	},

	PickedUpOneAppetizer = 
	{
		action = function()		
			PauseServerPickup();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_APPETIZER", next = "AppetizerDelivered" },
		}
	},
	
	AppetizerDelivered = 
	{
		action = function()
			TextBox(30, 180, "tutorialStep4", 9999000);
			HideArrows();
		end,
		triggers =
		{
			[1] = { condition = "REQUEST_DESIRE", parameter = "WANT_DINNER", next = "DinnerTime" },
		}
	},	

	DinnerTime = 
	{
		action = function()
			RestrictServerPickUpToDinnersOnly();
			TextBox(200, 380, "tutorialStep5", 9999000);
			HideArrows();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_PICKEDUP", parameter = "BONUS_DINNER", next = "PickedUpOneDinner" },
		}
	},

	PickedUpOneDinner = 
	{
		action = function()
			PauseServerPickup();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_DINNER", next = "Guest2Arrives" },
		}
	},

	Guest2Arrives = 
	{
		action = function()
			UnpauseSeating();
			TextBox(55, 90, "tutorialStep6", 9999000);
			HideArrows();
		end,
		triggers =
		{
			[1] = { condition = "REQUEST_DESIRE", parameter = "WANT_SIT", next = "NeedToSeatGuest2" },
		}
	},
	
	NeedToSeatGuest2 =
	{
		action = function()
			PauseSeating();
		end,
		triggers =
		{
			[1] = { condition = "IS_SEATED", parameter = "", next = "Guest2Seated" },
		}
	},	

	Guest2Seated = 
	{
		action = function()
			UnpauseSeating();
			RestrictSeatingToSpecificChairNumber( 1 );
			RestrictServerPickUpToCakeOnly();
			TextBox(200, 380, "tutorialStep7", 9999000);
			HideArrows();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_PICKEDUP", parameter = "BONUS_CAKE", next = "GotOneCake" },
		}
	},

	GotOneCake = 
	{
		action = function()
			PauseServerPickup();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_CAKE", next = "CakeDelivered" },
		}
	},
	
	CakeDelivered = 
	{
		action = function()
			UnpauseSeating();
			TextBox(480, 205, "tutorialStep8", 9999000);
			HideArrows();
		end,
		triggers =
		{
			[1] = { condition = "IS_SEATED", parameter = "", next = "Guest3Seated" },
		}
	},


	Guest3Seated = 
	{
		action = function()
			TextBox(480, 205, "tutorialStep9", 9999000);
			HideArrows();
			RestrictServerPickUpToGiftsOnly();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_GIFT", next = "Gift2Delivered" },
		}
	},


	Gift2Delivered = 
	{
		action = function()
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_GIFT", next = "Gift3Delivered" },
		}
	},


	Gift3Delivered = 
	{
		action = function()
			TextBox(200, 380, "tutorialStep10", 9999000);
			HideArrows();
			RestrictServerPickUpToAppetizersOnly();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_APPETIZER", next = "Appetizer2Delivered" },
		}
	},

	Appetizer2Delivered = 
	{
		action = function()
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_APPETIZER", next = "Appetizer3Delivered" },
		}
	},

	Appetizer3Delivered = 
	{
		action = function()
			TextBox(30, 180, "tutorialStep11", 9999000);
			HideArrows();
			RestrictServerPickUpToDinnersOnly();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_DINNER", next = "Dinner2Delivered" },
		}
	},

	Dinner2Delivered = 
	{
		action = function()
			TextBox(30, 180, "tutorialStep11", 9999000);
			HideArrows();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_DINNER", next = "UhOhBridesMaids" },
		}
	},
	


	UhOhBridesMaids = 
	{
		action = function()
			StartBridesMaids();
			TextBox( 240, 380, "tutorialStep12", 9999000);
			HideArrows();
			PauseServerPickup();
			PauseRequests();
		end,
		triggers =
		{
			[1] = { condition = "QUINN_EVENT_STARTED", parameter = "QUINN_ON_HER_WAY", next = "ProblemClicked" },
		}
	},

	ProblemClicked = 
	{
		action = function()
			TextBox( 240, 380, "tutorialStep13", 9999000);
			HideArrows();
			UnpauseRequests();
		end,
		triggers =
		{
			[1] = { condition = "REQUEST_DESIRE", parameter = "WANT_CAKE", next = "CakeTime" },			
		}
	},

	CakeTime =
	{
		action = function()
			TextBox(30, 130, "tutorialStep14", 10000);
			HideArrows();
			RestrictServerPickUpToCakeOnly();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_CAKE", next = "Cake2Delivered" },
		}
	},


	Cake2Delivered =
	{
		action = function()
			TextBox(30, 130, "tutorialStep14", 10000);
			HideArrows();
		end,
		triggers =
		{
			[1] = { condition = "ITEM_DELIVERED", parameter = "BONUS_CAKE", next = "DoneWithTutorial" },
		}
	},


	DoneWithTutorial =
	{
		action = function()
			TextBox(30, 130, "tutorialStep15", 10000);
			HideArrows();
		end,
		triggers =
		{
		}
	}
}


